%{
Copyright (c) 2011, MIT.
Developed with the sponsorship of the Defense Advanced Research Projects
Agency (DARPA).

Permission is hereby granted, free of charge, to any person obtaining a copy
of this data, including any software or models in source or binary form, as
well as any drawings, specifications, and documentation (collectively "the
Data"), to deal in the Data without restriction, including without
limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Data, and to permit persons to whom
the Data is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE DATA OR
THE USE OR OTHER DEALINGS IN THE DATA.
%}

function fuzzyParetoNumbers = calcFuzzyParetoNumbers(Utility,Cost)
% This function calculates the minimum XX% Fuzzy Pareto Set for XX = 0:100
% necessary for a design to be included, for each design in each epoch.

% Inputs:
% Utility should be the utility matrix (i,j) for i=design, j=epoch, using
% either single or multi attribute utility
% Cost should be the cost for each design in each epoch, oganized the same
% way.  OPERATING costs should be used if intending to use this function
% with changeability analysis tools.

% Requirements:
% calls gen_pareto_set.m

numdesigns = size(Utility,1);
numepochs = size(Utility,2);

fuzzyParetoNumbers = -ones(numdesigns,numepochs);

% set all NaN's to 0 utility, max cost for the purposes of calculating fuzzy
% percentages
idx = isnan(Utility);
Utility(idx) = 0;
Cost(idx) = max(max(Cost));

for epoch = 1:numepochs
    disp(['Calculating Fuzzy Pareto Levels for epoch: ' num2str(epoch)])
    for percent = 100:-1:0
        currSet = gen_pareto_set([Utility(:,epoch),Cost(:,epoch)],[1 0],1,false,percent/100);
        fuzzyParetoNumbers(currSet,epoch) = percent;
    end
end

% retroactively set all NaNs to fuzzy pareto 100
fuzzyParetoNumbers(idx) = 101;


end